﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Recipe_1._3
{
    public partial class FormEdit : Form
    {
        /// <summary>
        /// Private fields for storing info entered by user into form:
        /// </summary>
        private string m_OriginalItemName;
        private string m_NewItemName;
        private string m_ItemIngredients;
        private string m_ItemDirections;
        private string m_ItemTips;
        private byte[] m_ItemImage;

        /// <summary>
        /// Public properties for accessing info entered by user into form:
        /// </summary>
        public string OriginalItemName
        {
            get { return m_OriginalItemName; }
        }

        public string NewItemName
        {
            get { return m_NewItemName; }
        }
        
        public string ItemIngredients
        {
            get { return m_ItemIngredients; }
        }

        public string ItemDirections
        {
            get { return m_ItemDirections; }
        }

        public string ItemTips
        {
            get { return m_ItemTips; }
        }

        public byte[] ItemImage
        {
            get
            {
                if (this.pboxImage.Image == null)  // there is no image to return:
                    return null;
                else if (this.m_ItemImage != null) // there is an image, and we have bytes already:
                    return this.m_ItemImage;
                else  // we have an image, but this is the first call to get underlying bytes:
                {
                    System.IO.MemoryStream ms;
                    System.Drawing.Image image;

                    //
                    // for image, we need the raw bytes that make up the image:
                    //
                    ms = new System.IO.MemoryStream();
                    image = this.pboxImage.Image;
                    image.Save(ms, image.RawFormat);
                    this.m_ItemImage = ms.GetBuffer();

                    return this.m_ItemImage;
                }//else
            }//get
        }

        /// <summary>
        /// Constructor:
        /// </summary>        
        public FormEdit()
        {
            InitializeComponent();
        }

        /// <summary>
        /// This method is called automatically when the form is created but before the user sees it:
        /// </summary>
        private void FormEdit_Load(object sender, EventArgs e)
        {            
            // TODO: This line of code loads data into the 'itemsDatabaseDataSet.Items_Table' table. You can move, or remove it, as needed.
            this.items_TableTableAdapter.Fill(this.itemsDatabaseDataSet.Items_Table);
        }

        /// <summary>
        /// This method is called when the user clicks the cancel button:
        /// </summary>
        private void cmdCancel_Click(object sender, EventArgs e)
        {
            //
            // set dialog result to cancel, so main form knows that user cancelled:
            //
            // NOTE: this also closes the window when shown as a dialog.
            //
            this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
        }
        /// <summary>
        /// This method is called when the load image button is clicked to load an image into the
        ///   picture box, and ultimately the database.
        /// </summary>
        private void cmdChangeImage_Click(object sender, EventArgs e)
        {
            System.Windows.Forms.DialogResult result;

            // set filter to just show .jpg and .bmp image files:
            this.openFileDialog1.Filter = "Pictures (*.JPG;*.BMP)|*.JPG;*.BMP";

            // clear filename from last time:
            this.openFileDialog1.FileName = "";

            // now show standard file open dialog and request a file name:
            result = this.openFileDialog1.ShowDialog();

            // did user cancel?
            if (result == System.Windows.Forms.DialogResult.Cancel)
                return;

            // ok, display image in picture box:
            this.pboxImage.Image = System.Drawing.Image.FromFile(this.openFileDialog1.FileName);
        }

        /// <summary>
        /// This method is called when the user clicks the save button to update the item in the database.
        ///   Note that the work of actually updating the item in the database is done by the mainform,
        ///   our goal here is to collect the information and inform the mainform of the user's 
        ///   intentions.
        /// </summary>     
        private void cmdSave_Click(object sender, EventArgs e)
        {
            //
            // make sure user entered a name:
            //
            if (this.combName.Text == "")
            {
                MessageBox.Show("You must enter a name for the recipe...", "Cook Book", MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.combName.Focus();  // move focus there for user to fix:
                return;
            }

            //
            // retrieve values from text boxes and store into fields of this form:
            //
            this.m_OriginalItemName = this.combName.Text;
            this.m_NewItemName = this.txtNewName.Text;
            this.m_ItemIngredients = this.txtIngredients.Text;
            this.m_ItemDirections = this.txtDirections.Text;
            this.m_ItemTips = this.txtTips.Text;
            this.m_ItemImage = null;         

            long iid;     // retrieve IID_PK from Tag (as a string), then convert to what we need (long integer)
            iid = System.Convert.ToInt64(this.combName.Tag);

            //
            //Update the database with the new information
            //
            if (NewItemName == "")
            {
                this.items_TableTableAdapter.Update(OriginalItemName, ItemImage, ItemDirections, ItemIngredients, ItemTips, iid, OriginalItemName);
            }
            else
            {
                this.items_TableTableAdapter.Update(NewItemName, ItemImage, ItemDirections, ItemIngredients, ItemTips, iid, OriginalItemName);
            }            
            // Filling the database will be handled by the main form
            //
            // NOTE: this closes the window when shown as a dialog.
            //
            this.DialogResult = System.Windows.Forms.DialogResult.OK;
        }

    }
}
